Attribute VB_Name = "modGeneral"
'
' Copyright  2002 David Scarmozzino
'      All Rights Reserved
' http://www.TheScarms.com/AppSentinel
'         TheScarms (TM)
'
' This source code may not be redistributed. Redistributing
' this source code is a violation of copyright laws.
'
' This sample program was designed to serve as an example
' of calling the various methods of the AppSentinel DLLs.
'
' It is not intended to be used "as is" in your production
' application. The actual logic and sequence of DLL method
' calls must be designed to suit your specific needs.

' Create a variable to reference the AppSentinel object.
'
' IMPORTANT:
' READ ObjectBinding.htm BEFORE RUNNING/CHANGING THIS CODE.
'
'Public gobjAppSentinel As New SEN10L.Registration  'Release version
'Public gobjAppSentinel As New SEN10LT.Registration 'Trial version
Public gobjAppSentinel As Object

' Your app's name and your company's name.
' No spaces or strange characters allowed.
Public Const cYourAppName = "YourAppName4"
Public Const cYourCompanyName = "YourCompanyName"

' Registry key in which to store data.
Public Const cSubKey = cYourCompanyName & "\" & cYourAppName

Public Sub pCenterForm(Frm As Form, Optional ByVal lngOffset As Long = 0)
    
    With Frm
        .Left = (Screen.Width - .Width) / 2
        .Top = ((Screen.Height - .Height) / 2) - lngOffset
    End With

End Sub


Public Sub Main()
Dim lngResult As Long
Dim strTemp   As String
Dim strError  As String
    
    ' Only allow one instance of your app. Center the form.
    If App.PrevInstance Then End
    
    ' IMPORTANT:
    ' READ ObjectBinding.htm BEFORE RUNNING/CHANGING THIS CODE.
    
    'Set gobjAppSentinel = CreateObject("SEN10L.Registration")
    Set gobjAppSentinel = CreateObject("SEN10LT.Registration")
    '
    ' Establish your evaluation period and set required parameters.
    '
    ' Parameter       Description
    ' --------------  -------------------------------------------------
    ' FileMask        Required. Suggested length - 10 characters.
    '                 Used to create the names of the files which
    '                 store your application's registration data.
    '                 Mask should be unique. If AppSentinel is used in
    '                 more than one of your applications, use a
    '                 different mask in each application.
    '
    ' RegistrySubkey  Required. Typically: YourCompanyName\YourAppName
    '
    ' TrialDays*      Optional. The number of days to allow in your
    '                 evaluation period.
    ' TrialRuns*      Optional. The number of times your application
    '                 can be used during your evaluation period.
    '
    ' * TrialDays or TrialRuns or both must be set.
    '
    '
    ' Set your evaluation period and required parameters.
    '
    ' Parameter       Description
    ' --------------  -------------------------------------------------
    ' FileMask        Required. Suggested length - 10 characters.
    '                 Used to create the names of the files which
    '                 store your application's registration data.
    '                 Mask should be unique. If AppSentinel is used in
    '                 more than one of your applications, use a
    '                 different mask in each application.
    '
    ' RegistrySubkey  Required. Typically: YourCompanyName\YourAppName
    '
    ' TrialDays*      Optional. The number of days to allow in your
    '                 evaluation period.
    ' TrialRuns*      Optional. The number of times your application
    '                 can be used during your evaluation period.
    '
    ' * TrialDays or TrialRuns or both must be set.
    '
    gobjAppSentinel.TrialDays = 20
    gobjAppSentinel.TrialRuns = 50
    gobjAppSentinel.FileMask = "YourFileMask4"
    gobjAppSentinel.RegistrySubkey = cSubKey
    
    ' Check the registration information.
    lngResult = fRegister(strError)
    
    Select Case lngResult
        Case cregRegistered
            ' App is registered. You may want to enable certain
            ' features, hide your registration screen,....
            'Call pDoRegistrationStuff()
            '
            ' You probably don't want to show this message.
            Call MsgBox("Your Application is Registered", vbInformation, "Registered Version")
            
            ' Show your first form.
            frmMain.Show vbModal
        Case cregEvaluating
            ' Trial period has time and/or runs left.
            ' You can tell the user and tell them how to register.
            If gobjAppSentinel.DaysLeft <> "" Then
                strTemp = "You have " & gobjAppSentinel.DaysLeft & " day(s) remaining."
            End If
            If gobjAppSentinel.RunsLeft <> "" Then
                If strTemp <> "" Then strTemp = strTemp & vbCrLf
                strTemp = "You have " & gobjAppSentinel.RunsLeft & " run(s) remaining."
            End If
            Call MsgBox(strTemp, vbInformation, "Evaluation Version")
            
            ' You may want to show your nag screen, disable features,...
            'Call pDoEvaluationStuff()
            
            ' Show your first form.
            frmMain.Show vbModal
        Case cregExpired
            '
            ' The evaluation period has expired.
            '
            Call MsgBox("Your evaluation period has expired.", vbCritical, "Evaluation Period Expired")
            ' Trial period expired.
            Call MsgBox("Your evaluation period has expired.", vbCritical, "Evaluation Period Expired")
            ' This sample has logic in fRegister to redisplay the
            ' registration form giving the user a chance to register.
            '
            ' NOTE:
            ' If you terminate your app using the END statement, you MUST
            ' Set gobjAppSentinel = Nothing first. See ObjectBinding.htm.
            Call MsgBox("This application will shut down.", vbCritical, "Evaluation Period Expired")
            Set gobjAppSentinel = Nothing
            Exit Sub
        Case cregError
            ' Something went wrong. Tell the user.
            Call MsgBox(strError, vbCritical, "Error Verifying Registration")
            ' Assume the app is not registered and end your program.
            Set gobjAppSentinel = Nothing
            Exit Sub
            ' If strError is an 'Internal Error', report the problem to
            ' Sales@TheScarms.com providing as much detail as possible.
    End Select

    ' You should always do this.
    Set gobjAppSentinel = Nothing
End Sub
Private Function fRegister(ByRef strError As String) As Long

    '
    '---------------------------------------------------------------------
    ' Check the registration status of your application.
    '
    ' Return:
    '   cregRegistered - Properly Registered.
    '   cregEvaluating - Not registered. Evaluation period not expired.
    '   cregExpired    - Not registered. Evaluation period expired.
    '   cregError      - Error occured.
    '
    '   strError       - Contains the error message on error.
    '---------------------------------------------------------------------
    '
    strError = ""
    fRegister = cregExpired
    On Error GoTo ErrorHandler

    ' Read/check registration information.
    If Not gobjAppSentinel.GetRegistrationInfo(strError) Then GoTo ErrorHandler
    If Not gobjAppSentinel.CheckRegistration(strError) Then GoTo ErrorHandler
    
    ' See if application is registered.
    If gobjAppSentinel.Registered Then
        fRegister = cregRegistered
        Exit Function
    End If
    
    If gobjAppSentinel.Expired Then
        ' Trial period has expired.
        fRegister = cregExpired
        
        ' Show registration form and recheck
        ' registration in case user just registered.
        frmRegister.Show vbModal
        If Not gobjAppSentinel.GetRegistrationInfo(strError) Then GoTo ErrorHandler
        If Not gobjAppSentinel.CheckRegistration(strError) Then GoTo ErrorHandler
        If gobjAppSentinel.Registered Then fRegister = cregRegistered
    Else
        'Still within trial period.
        fRegister = cregEvaluating
    End If
    Exit Function
    
ErrorHandler:
    ' A method of AppSentinel returned false. Assume
    ' your application is not registered or expired.
    fRegister = cregError
    If strError = "" Then strError = Err.Description
End Function

